/**********************************************************************
 *<
	FILE: SplExp.h

	DESCRIPTION:	Spline Export Class

	CREATED BY:

	HISTORY:

 *>	Copyright (c) 1997, All Rights Reserved.
 **********************************************************************/

#ifndef __SPLEXP_H
#define __SPLEXP_H

#include "rwcommon.h"
#include "material.h"
#include "remapper.h"

class CBspDlg;

class SPLExport : public SceneExport
{
public:
                    SPLExport();                        /* Constructor */
                    ~SPLExport();                       /* Destructor */
    int             ExtCount();                         /* Number of extensions supported */
    const TCHAR *   Ext(int n);                         /* Extension #n (i.e. "3DS") */
    const TCHAR *   LongDesc();                         /* Long ASCII description (i.e. "Autodesk 3D Studio File") */
    const TCHAR *   ShortDesc();                        /* Short ASCII description (i.e. "3D Studio") */
    const TCHAR *   AuthorName();                       /* ASCII Author name */
    const TCHAR *   CopyrightMessage();                 /* ASCII Copyright message  */
    const TCHAR *   OtherMessage1();                    /* Other message #1 */
    const TCHAR *   OtherMessage2();                    /* Other message #2 */
    unsigned int    Version();                          /* Version number * 100 (i.e. v3.01 = 301) */
    void            ShowAbout(HWND hWnd);               /* Show DLL's "About..." box */
    int             DoExport(const TCHAR *name, 
                             ExpInterface *ei,Interface *i, BOOL suppressPrompts, DWORD options); /* Export file */

private:
    RwLib *             m_rwlib;
    float               m_nScaleFactor;
};

class SPLClassDesc:public ClassDesc
{
public:    
    int             IsPublic() { return 1; }
    void *          Create(BOOL loading = FALSE) { return new SPLExport; }
    const TCHAR *   ClassName() { return _T("SPL"); }
    SClass_ID       SuperClassID() { return SCENE_EXPORT_CLASS_ID; }
    Class_ID        ClassID() { return Class_ID(0x5b9e2130, 0xacd1b69); }
    const TCHAR *   Category() { return _T("SPL Exporter"); }
};

#endif // __SPLEXP_H
